string GetDescription()
{
	return "Renders the harmony into a disco style octave jumping bass";
}

void Render(RenderPart @p)
{
	double delta = 0.5;
	
	if (p.GetTempo() < 125) delta = 0.25;
	
	Time t = CreateTime(p.GetStartBar(), 0);

	int n = 0;
		
	while (t.m_Bar < p.GetEndBar())
	{
		int harm = p.GetHarmonic(t);
		int pit = p.GetHarmonicEventPitch(harm, 0); 
		
		Time t2 = t;
		t2.m_Pos += delta * 0.95;
		
		if (n == 0)
		{
			p.AddNote(t, t2, pit, RndInt(125,127));
			n = 1;	
		}
		else
		{
			p.AddNote(t, t2, p.AlignPitch(pit,7), RndInt(105,117));
			n = 0;
		}
		
		t.m_Pos += delta;
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Pos = 0;		
			t.m_Bar++;
			
		}
	}
}
